import UIKit
import MapKit
import XCPlayground

let extraLightBlur = UIBlurEffect(style: .ExtraLight)
let cornerRadius : CGFloat = 8

class BlurredRoundedView: UIView {
    let effectBackground = UIVisualEffectView(effect: extraLightBlur)
    
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
        commonInit()
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        commonInit()
    }
    
    func commonInit()  {
        initLayer()
        initEffectView()
    }
    
    func initLayer() {
        backgroundColor = UIColor.clearColor()
        layer.cornerRadius = cornerRadius
        layer.masksToBounds = false
    }
    
    func initEffectView() {
        effectBackground.frame = bounds
        effectBackground.layer.cornerRadius = cornerRadius
        effectBackground.layer.masksToBounds = true

        addSubview(effectBackground)
        sendSubviewToBack(effectBackground)
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        let shadowPath = UIBezierPath(roundedRect: bounds, cornerRadius: cornerRadius)
        layer.masksToBounds = false
        layer.shadowColor = UIColor.lightGrayColor().CGColor
        layer.shadowOffset = CGSizeMake(0.0, 0.0)
        layer.shadowOpacity = 0.4
        layer.shadowRadius = 4
        layer.shadowPath = shadowPath.CGPath
    }
}

let view = UIView(frame: CGRect(x: 0, y: 0, width: 320, height: 480))

let delta = 10.0
let frame = CGRect( x:0, y:0, width:200, height:200 )
let mapView = MKMapView( frame: view.bounds )
var region = MKCoordinateRegion()
region.center.latitude = 42.6
region.center.longitude = 11.9
region.span.latitudeDelta = delta
region.span.longitudeDelta = delta
mapView.setRegion( region, animated: true )

view.addSubview(mapView)

let floatingView = BlurredRoundedView(frame: CGRect(x: 60, y: 60, width: 200, height: 360))

view.addSubview(floatingView)

XCPlaygroundPage.currentPage.liveView = view
XCPlaygroundPage.currentPage.needsIndefiniteExecution = true

